﻿var columnItems = [];
var selectedItems = [];

var nameTables = {
    context: $(".v-lookupTableName"),
    datatable: null,
    changeCategoryItems: null,
    refreshDataTable: function () {
        nameTables.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-tablesTable").a4datatable({
            advancedFilter: true,
            height: "full",
            stateKey: "LookupTableName",
            ajaxAction: a4.getAction("GetLookupTableName", "Surveys", "Settings", { id: lookupTablesId }),
            columns: columnItems,
            localizableTexts: { "Search": resources.SearchChoices },
            selectRow: function (event, data) {
                selectedItems = data.selectedRows;
            },
            toolBar: {
                DisplayMode: dataTables.filterDisplayMode.dropdown,
                Items: nameTables.getToolBarItems(),
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = [];

                for (var i = 0; i < rows.length; i++) {
                    ids.push(rows[i].InternalId);
                }

                switch (action) {
                    case "delete":
                        nameTables.deleteItems(ids);
                        break;
                    case "public":
                        nameTables.quickActions(ids, "setPublic");
                        break;
                    case "private":
                        nameTables.quickActions(ids, "setPrivate");
                        break;
                    case "visible":
                        nameTables.quickActions(ids, "setVisible");
                        break;
                    case "invisible":
                        nameTables.quickActions(ids, "setInvisible");
                        break;
                    case "merge":
                        modalDialog.showWindow(a4.getAction("EditLookupTableName", "Surveys", "Settings", { id: 0, tableId: lookupTablesId, mergeIds: ids }),
                            450, 650,
                            { afterClose: function () { nameTables.refreshDataTable(); } });
                        break;
                }


            },
            contextMenuItems: nameTables.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        modalDialog.showWindow(a4.getAction("EditLookupTableName", "Surveys", "Settings", { id: row.InternalId, tableId: lookupTablesId }),
                            450, 650,
                            { afterClose: function () { nameTables.refreshDataTable(); } });
                        break;
                    case "public":
                        nameTables.quickActions(row.InternalId, "setPublic");
                        break;
                    case "private":
                        nameTables.quickActions(row.InternalId, "setPrivate");
                        break;
                    case "visible":
                        nameTables.quickActions(row.InternalId, "setVisible");
                        break;
                    case "invisible":
                        nameTables.quickActions(row.InternalId, "setInvisible");
                        break;
                    case "delete":
                        nameTables.deleteItems(row.InternalId);
                        break;
                }
            }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addTable", function () {
            modalDialog.showWindow(a4.getAction("EditLookupTableName", "Surveys", "Settings",
                { id: 0, tableId: lookupTablesId }), 450, 650, {
                afterClose: function () { nameTables.refreshDataTable(); }
            });
        });
    },
    deleteItems: function (items) {
        a4.showBusyBox();
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        a4.callServerMethod(a4.getAction("GetSurveyReferences", "Surveys", "Settings"), { tableIds: lookupTablesId },
            function (result) {
                a4.hideBusyBox();
                var height = 250;
                var deleteContainer = $("#deleteTableContainer").clone();
                var useResources = confirmDeleteResources;

                if (_.size(result.data) > 0) {
                    var ul = $("ul", deleteContainer);

                    // Add surveys
                    $.each(result.data, function (i, val) {
                        ul.append("<li>" + val + "</li>");
                        height += 50;
                    });

                    messageContent = deleteContainer.html();
                    useResources = modalDialog.createDialogResources(messageContent, confirmDeleteResources.Title, confirmDeleteResources.CheckBoxText, confirmDeleteResources.ConfirmButton);
                }

                modalDialog.showConfirmDialog(useResources, function () {
                    a4.callServerMethod(a4.getAction("DeleteLookupTableName", "Surveys", "Settings"), { tableId: lookupTablesId, ids: items }, function (result) {
                        nameTables.refreshDataTable();
                    });
                }, height, 550, true, { "count": itemsCount, confirmButtonType: "primary-attention" });
            },
            function () { }
        );
    },
    quickActions: function (items, actionName) {
        a4.showBusyBox();
        var itemsCount = items.length;
        if (itemsCount === undefined) {
            itemsCount = 1;
        }

        a4.callServerMethod(a4.getAction("QuickActionsForLookupTableName", "Surveys", "Settings"), { tableId: lookupTablesId, actionName: actionName, ids: items },
            function (result) {
                nameTables.refreshDataTable();
                a4.hideBusyBox();
            },
            function () { }
        );
    },
    getContextMenuItems: function () {
        var items = [];

        if (canModifySettings) {
            items = [
                { "Action": "edit", "Label": resources.EditChoice },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "public", "Label": resources.SetAsPublicizeChoice, "DisplayCondition": function (data) { return data.InternalPrivate; } },
                { "Action": "visible", "Label": resources.SetAsVisibleChoice, "DisplayCondition": function (data) { return !data.InternalVisible; } },
                { "Action": "invisible", "Label": resources.SetAsInvisibleChoice, "DisplayCondition": function (data) { return data.InternalVisible; } },
            ]
        }

        return items;
    },
    getToolBarItems: function () {
        var items = [];

        if (canModifySettings) {
            items =   [
                { "Action": "merge", "Label": resources.MergeSelection, "DisplayCondition": function (data) { return nameTables.showToolbarButtons("merge", true); } },
                { "Action": "delete", "Label": resources.DeleteSelection },
                { "Action": "public", "Label": resources.SetSelectionPublic, "DisplayCondition": function (data) { return nameTables.showToolbarButtons("private", true); } },

                { "Action": "visible", "Label": resources.SetSelectionVisible, "DisplayCondition": function (data) { return nameTables.showToolbarButtons("visible", false); } },
                { "Action": "invisible", "Label": resources.SetSelectionHidden, "DisplayCondition": function (data) { return nameTables.showToolbarButtons("visible", true); } },
            ]
        }

        return items;
    },

    showToolbarButtons: function (action, status) {
        var rows = nameTables.datatable.a4datatable("getSelectedItems");
        if (action == "private") {
            return rows.some(x => x.InternalPrivate == status);
        }
        if (action == "visible") {
            return rows.some(x => x.InternalVisible == status);
        }
        if (action == "merge") {
            return rows.length > 1;
        }
        return false;
    }
}

$(document).ready(function () {
    if (nameTables.context.length > 0) {
        a4.showBusyBox();

        a4.callServerMethod(a4.getAction("GetLookupTableNameColumns", "Surveys", "Settings"), { id: lookupTablesId },
            function (result) {
                a4.hideBusyBox();

                result.forEach((item) => {

                    var newItem = {
                        "Name": item,
                        "Data": item,
                        "Visible": true,
                        "Title": setTitle(item),
                        "Class": item == "InternalId" ? "id" : "",
                        "Key": item == "InternalId" ? true : false,
                        "Type": getType(item)
                    };

                    if (item == "InternalSource") {
                        newItem.EnumType = "SourceFilterType";
                        newItem.Class = "no-wrap";
                        newItem.render = function (cellData) {
                            if (cellData != null) {
                                return EnumDetails.SourceFilterType.find(x => x.Value == cellData).Label;
                            }
                            return cellData;
                        };
                    }

                    if (item == "InternalVisible" || item == "InternalPrivate") {
                        newItem.render = function (cellData) {
                            return cellData == true ? '<span class="icon"><i class="fa fa-check"></i></span>' : '';
                        };
                    }

                    columnItems.push(newItem);
                });

                nameTables.initializeDataTable();
                nameTables.bindEvents();
            }, function (error) {
                a4.onAjaxPageMethodError(error);
            });
    }

    function getType(fieldName) {
        if (fieldName == "InternalPrivate" || fieldName == "InternalVisible") {
            return "boolean";
        }

        if (fieldName == "InternalSource") {
            return "enum";
        }

        return "string";
    }

    function setTitle(fieldName) {
        var systemNames = ["InternalRespondent", "InternalSurveyId", "InternalSurveyName", "InternalSource", "InternalPrivate", "InternalVisible", "InternalId"];
        if (systemNames.includes(fieldName)) {
            return resources[fieldName.replace("Internal", "")];
        }
        return fieldName;
    }
});